#ifndef __DM_SYSCMDS_H__
#define __DM_SYSCMDS_H__

#include "dm_nutypedefs.h"

#ifdef __cplusplus
extern "C" {
#endif

extern void RestoreFactoryDefaults(void);
extern UINT16 GetCodeChecksum(void);
extern INT32 EchoCmd(UINT32 ignore, char *cmd);
extern INT32 RestoreCmd(UINT32 ignore, char *cmd);
extern INT32 InfoCmd(UINT32 ignore, char *cmd);
extern INT32 ReadWritePhysicalMemory(UINT32 WriteFlag, char *cmd);
extern INT32 VersionCmd(UINT32 ignore, char *cmd);
extern INT32 RebootCmd(UINT32 ignore, char *cmd);
extern INT32 SelfTestCmd(UINT32 ignore, char *cmd);
extern INT32 UptimeCmd(UINT32 ignore, char *cmd);
extern INT32 SystemCmd(UINT32 ignore, char *ncmd);
extern INT32 HelpCmd(UINT32 ignore, char *cmd);
extern INT32 TSIDCmd(UINT32,char*);
INT32 TasksShowCmd(UINT32 ignore, char *cmd);
extern INT32 HeapTestCmd(UINT32 argc, char * cmd);
extern INT32 MemoryTest(UINT32 ignore, char *cmd);
extern INT32 DmHDBaseTUartConfigCmd(UINT32 ignore, char *cmd);
extern void (*pfuncDmHDBaseTUartConfig)(int bStream, UINT8 bUartConfigType, int cmdSet);
extern UINT8   g_bNumberOfDMHDBaseTUarts;


#ifndef DM_HDBASET_UART_CONFIG_TYPE_SERIAL_PORT
#define DM_HDBASET_UART_CONFIG_TYPE_SERIAL_PORT 0xAA // HDBaseT Forced to be DMNET
#endif                             
#ifndef DM_HDBASET_UART_CONFIG_TYPE_AUTO_DETECT
#define DM_HDBASET_UART_CONFIG_TYPE_AUTO_DETECT 0    // HDBaseT not Forced
#endif                     
#ifndef DM_HDBASET_UART_CONFIG_TYPE_DMNET
#define DM_HDBASET_UART_CONFIG_TYPE_DMNET       0x55 // HDBaseT Forced to be Serial Port
#endif

#ifdef __cplusplus
}
#endif

#endif  //__DM_SYSCMDS_H__

